<?php
/*--------------------------------------------------------------
   Moved.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Events;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\HorizontalPosition;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\VerticalPosition;

class Moved
{
    /**
     * @var Id
     */
    private $id;
    
    /**
     * @var VerticalPosition
     */
    private $verticalPosition;
    
    /**
     * @var HorizontalPosition
     */
    private $horizontalPosition;
    
    
    /**
     * Constructor.
     */
    private function __construct(
        Id $id,
        HorizontalPosition $horizontalPosition,
        VerticalPosition $verticalPosition
    ) {
        $this->id                 = $id;
        $this->horizontalPosition = $horizontalPosition;
        $this->verticalPosition   = $verticalPosition;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(
        Id $id,
        HorizontalPosition $horizontalPosition,
        VerticalPosition $verticalPosition
    ): self {
        return new self($id, $horizontalPosition, $verticalPosition);
    }
    
    
    /**
     * Return ID.
     */
    public function id(): Id
    {
        return $this->id;
    }
    
    
    /**
     * Return vertical position.
     */
    public function verticalPosition(): VerticalPosition
    {
        return $this->verticalPosition;
    }
    
    
    /**
     * Return horizontal position.
     */
    public function horizontalPosition(): HorizontalPosition
    {
        return $this->horizontalPosition;
    }
}